#include "../generator.h"
#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"

static Obj3d Ping;
static Obj3d *pPlaque;
static float Matrix[16], Matrix2[16], Matrix3[16], Gouraud[16], Gouraud2[16];

void LInit_Ping2()
{
	FILE *file;
	DWORD Cpt1;
	unsigned short A,B,C;
	float fMinX,fMaxX,fMinY,fMaxY;
	float fRangeX, fRangeY;

	// load ping!
	//file = fopen("Ping.n3d", "rb");
	file = fopen("Canard.n3d", "rb");
	fread(&Ping.NbVertex, 4, 1, file);
	Ping.pVertexIn = (FbVertex*)malloc(sizeof(FbVertex)*Ping.NbVertex);
	Ping.pVertexOut = (GrVertex*)malloc(sizeof(GrVertex)*Ping.NbVertex);
	for(Cpt1=0;Cpt1<Ping.NbVertex;Cpt1++)
	{
		fread(&Ping.pVertexIn[Cpt1].x, 4, 1, file);
		fread(&Ping.pVertexIn[Cpt1].y, 4, 1, file);
		fread(&Ping.pVertexIn[Cpt1].z, 4, 1, file);
		fread(&Ping.pVertexIn[Cpt1].tmuvtx[0].sow, 4, 1, file);
		fread(&Ping.pVertexIn[Cpt1].tmuvtx[0].tow, 4, 1, file);
	}
	fread(&Ping.NbFaces, 4, 1, file);
	Ping.pFace = (Face*)malloc(sizeof(Face)*Ping.NbFaces);
	for(Cpt1=0;Cpt1<Ping.NbFaces;Cpt1++)
	{
		fread(&A, 2, 1, file);
		fread(&B, 2, 1, file);
		fread(&C, 2, 1, file);
		Ping.pFace[Cpt1].A = A;
		Ping.pFace[Cpt1].B = B;
		Ping.pFace[Cpt1].C = C;
	}
	fclose(file);
	// end load ping!

	// stand, little ping!
	BeIdentityMatrix(Matrix);
	//ScaleMatrix(Matrix, 17,17,17);
	RotateXMatrix(Matrix2, Matrix, 8192/4); // PI2 <=> 8192; PI/2 <=> 8192/4
	ApplyMatrix(&Ping, Matrix2);
	// end stand, little ping!

	// be illuminated, little ping!
	ComputeGouraud(&Ping);
	BeIdentityMatrix(Gouraud);
	// end be illuminated, little ping!

	// be scaled, little ping!
	for(Cpt1=0;Cpt1<Ping.NbVertex;Cpt1++)
	{
		Ping.pVertexIn[Cpt1].r /= 8.f;
		Ping.pVertexIn[Cpt1].g /= 8.f;
		Ping.pVertexIn[Cpt1].b /= 8.f;
	}

	// end be scaled, little ping!

	PrepareTextureFromArray(g_PicBigrid, 256, 256, &g_TextureBigrid);
}

void QInit_Ping2()
{
	grSstControl(GR_CONTROL_ACTIVATE);
	grDepthBufferMode(GR_DEPTHBUFFER_WBUFFER);
	grDepthBufferFunction(GR_CMP_LESS);
	grConstantColorValue(192<<24);
	grAlphaCombine(GR_COMBINE_FUNCTION_BLEND_OTHER, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_CONSTANT, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);

	grChromakeyValue(0);
	grChromakeyMode(GR_CHROMAKEY_DISABLE);
	grFogMode(GR_FOG_DISABLE);

	DownloadTexture(&g_TextureBigrid);
	SelectTexture(g_TextureBigrid);
}

void Effect_Ping2()
{
	float fTmp;

	fTmp = g_demostate.TickInEffect/300.f;

	BeIdentityMatrix(Matrix);
	BeIdentityMatrix(Gouraud);

	RotateYMatrix(Matrix2, Matrix, g_demostate.TickInEffect*2);
	RotateXMatrix(Matrix, Matrix2, g_demostate.TickInEffect);
	RotateYMatrix(Gouraud2, Gouraud, -g_demostate.TickInEffect*2);
	RotateXMatrix(Gouraud, Gouraud2, -g_demostate.TickInEffect);

	TranslateMatrix(Matrix, 0, 0, 4000);
	DrawWithMatrixEnv(&Ping, Matrix, Gouraud);
}

void ByeBye_Ping2()
{
	FreeTexture(&g_TextureBigrid);
}